/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import flash.io.BitInput;
import flash.io.BitLibrary;
import flash.io.FlashFilter;
import flash.io.TypeReader;
import flash.objects.FBitmap;
import flash.objects.FColor;
import flash.objects.FLossless;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class TagReaderImage {
    private BitInput bi;
    private BitLibrary bl;
    private TypeReader myTypeReader;
    private byte[] JPEGTable;
    private boolean isDebug;
    private FlashFilter myFilters;

    public TagReaderImage(boolean bl, BitInput bitInput, BitLibrary bitLibrary, TypeReader typeReader, FlashFilter flashFilter) {
        this.isDebug = bl;
        this.myFilters = flashFilter;
        if (this.isDebug) {
            System.out.println("Image Reader: Active");
        }
        this.bi = bitInput;
        this.bl = bitLibrary;
        this.myTypeReader = typeReader;
        this.JPEGTable = null;
    }

    public FBitmap parseBitmap(int n, long l) throws IOException {
        int n2;
        int n3;
        int n4 = n3 = (int)l;
        int n5 = 0;
        int n6 = 0;
        if (n == 0) {
            this.JPEGTable = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                this.JPEGTable[i] = (byte)this.bl.ui8();
            }
            return null;
        }
        int n7 = (int)this.bl.ui16();
        n4 = n3 -= 2;
        if (n == 3) {
            n6 = (int)this.bl.ui32();
            n4 = n6;
            n5 = (n3 -= 2) - n4;
        }
        byte[] byArray = null;
        if (n == 1) {
            byArray = new byte[n4 - 2 + (this.JPEGTable.length - 2)];
            for (n2 = 0; n2 < this.JPEGTable.length - 2; ++n2) {
                byArray[n2] = this.JPEGTable[n2];
            }
            this.bi.skip(2L);
            for (n2 = 0; n2 < n4 - 2; ++n2) {
                byArray[n2 + (this.JPEGTable.length - 2)] = (byte)this.bl.ui8();
            }
        } else if (n == 2 || n == 3) {
            int n8;
            int n9;
            int n10;
            byArray = new byte[n4];
            n2 = 0;
            for (n10 = 0; n10 < n4; ++n10) {
                byArray[n10] = (byte)this.bl.ui8();
            }
            n10 = 0;
            for (n9 = 1; n9 < 10 && n9 < n4; ++n9) {
                if ((byArray[n9 - 1] & 0xFF) != 255 || (byArray[n9] & 0xFF) != 216) continue;
                n10 = n9 - 1;
            }
            if (n10 > 0) {
                byte[] byArray2 = new byte[n4 - n10];
                for (n8 = 0; n8 < byArray2.length; ++n8) {
                    byArray2[n8] = byArray[n8 + n10];
                }
                byArray = null;
                byArray = byArray2;
                byArray2 = null;
            }
            n9 = 0;
            n8 = 0;
        }
        FBitmap fBitmap = new FBitmap(n7, n, byArray, this.myFilters.getFilter(4));
        fBitmap.setVersion(n);
        return fBitmap;
    }

    public FLossless parseLossless(int n, int n2) throws IOException {
        int n3 = (int)this.bl.ui16();
        int n4 = (int)this.bl.ui8();
        int n5 = (int)this.bl.ui16();
        int n6 = (int)this.bl.ui16();
        n2 -= 7;
        if (n4 == 3) {
            int n7;
            FLossless fLossless = new FLossless(n, n3, n4, n5, n6);
            BufferedImage bufferedImage = new BufferedImage(n5, n6, n == 2 ? 2 : 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n5, n6);
            graphics2D.fill(double_);
            fLossless.setImage(bufferedImage);
            int n8 = (int)this.bl.ui8();
            byte[] byArray = this.bl.uiBytes(--n2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BitInput bitInput = new BitInput(byteArrayInputStream);
            BitLibrary bitLibrary = new BitLibrary(bitInput);
            TypeReader typeReader = new TypeReader(bitLibrary, bitInput, 3);
            bitInput.zipStream();
            FColor[] fColorArray = new FColor[n8];
            for (n7 = 0; n7 < n8; ++n7) {
                fColorArray[n7] = typeReader.rgba(n == 1 ? 1 : 3);
            }
            n7 = 4 - ((int)bitInput.bitsRead & 3);
            bitInput.skip(n7);
            n7 = 4 - (n5 & 3);
            int n9 = 0;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    n9 = (int)bitLibrary.ui8();
                    if (n9 < 0 || n9 >= n8) continue;
                    FColor fColor = fColorArray[n9];
                    graphics2D.setPaint(fColor.toColor());
                    double_.setRect(j, i, 1.0, 1.0);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)fColor.getA() / 255.0f));
                    graphics2D.fill(double_);
                }
                if ((n5 & 3) == 0) continue;
                bitInput.skip(n7);
            }
            return fLossless;
        }
        if (n4 == 4) {
            FLossless fLossless = new FLossless(n, n3, n4, n5, n6);
            BufferedImage bufferedImage = new BufferedImage(n5, n6, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n5, n6);
            fLossless.setImage(bufferedImage);
            byte[] byArray = this.bl.uiBytes(n2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BitInput bitInput = new BitInput(byteArrayInputStream);
            BitLibrary bitLibrary = new BitLibrary(bitInput);
            bitInput.zipStream();
            Color color = null;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    int n10 = (int)bitInput.readBits(1, false);
                    int n11 = (int)bitInput.readBits(5, false);
                    int n12 = (int)bitInput.readBits(5, false);
                    int n13 = (int)bitInput.readBits(5, false);
                    color = new Color((int)((float)n11 / 31.0f * 255.0f), (int)((float)n12 / 31.0f * 255.0f), (int)((float)n13 / 31.0f * 255.0f));
                    graphics2D.setPaint(color);
                    double_.setRect(j, i, 1.0, 1.0);
                    graphics2D.fill(double_);
                }
            }
            return fLossless;
        }
        if (n4 == 5) {
            FLossless fLossless = new FLossless(n, n3, n4, n5, n6);
            BufferedImage bufferedImage = new BufferedImage(n5, n6, n == 2 ? 2 : 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n5, n6);
            if (n == 2) {
                graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                graphics2D.fill(double_);
            }
            fLossless.setImage(bufferedImage);
            byte[] byArray = this.bl.uiBytes(n2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BitInput bitInput = new BitInput(byteArrayInputStream);
            BitLibrary bitLibrary = new BitLibrary(bitInput);
            bitInput.zipStream();
            int[] nArray = new int[4];
            int n14 = 255;
            Color color = null;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        nArray[k] = (int)bitLibrary.ui8();
                    }
                    if (n == 2) {
                        n14 = nArray[0];
                    }
                    color = new Color(nArray[1], nArray[2], nArray[3]);
                    graphics2D.setPaint(color);
                    double_.setRect(j, i, 1.0, 1.0);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)n14 / 255.0f));
                    graphics2D.fill(double_);
                }
            }
            return fLossless;
        }
        return null;
    }
}

